VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CExcelTemplateProcessor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_ERRORRAISE As Long = 2500
Private Const SCREEN_NAME = "Cap_OfferExcelExport"
Private Const TEMPLATE_SHEET1_NAME = "Sheet1"

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Type tOFFER_TEMPLATE_TABLE
    DetailType As eDPCOfferDetailIsAlt
    Request As String
End Type

Private Enum XlDeleteShiftDirection
  xlShiftUp = -4162
End Enum

Private Enum XlInsertShiftDirection
  xlShiftDown = -4121
End Enum


Dim mo_TempTables() As tOFFER_TEMPLATE_TABLE
Dim mo_TempData() As String
Dim mo_Tools As DPC_Tools
Dim ml_CodePage As Long
Dim ms_Language_Code As String
Dim ms_OriginalWorkSheetName As String
Dim ms_ScreenName As String

#If LIVE = 1 Then
    Dim mo_Db As Object
    Dim mo_Excel As Object   ' Excel.Application
#Else
    Dim mo_Excel As Excel.Application
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Let Language(as_Language As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language
  Exit Property
ErrHandler:
  Call ErrorHandler("Language.Let")
End Property

Public Property Get Language() As String
On Error GoTo ErrHandler
  
  Language = ms_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language.Get")
End Property

Public Property Let ScreenName(as_ScreenName As String)
On Error GoTo ErrHandler
  
  ms_ScreenName = as_ScreenName
  Exit Property
ErrHandler:
  Call ErrorHandler("ScreenName.Let")
End Property

Public Function Load_A_COM() As Boolean
On Error GoTo ErrorHandler
    
    ' Create Word Application
    Set mo_Excel = CreateObject("Excel.Application")
    mo_Excel.Visible = False
    ReDim mo_TempTables(-1 To -1)
    ReDim mo_TempData(-1 To -1)
    ml_CodePage = mo_Tools.GetCodePageFromLanguage(mo_Db, ms_Language_Code)
    Load_A_COM = True
    Exit Function
ErrorHandler:
    Call ErrorHandler("Load_A_COM")
End Function

Public Sub Unload_A_COM()
    Set mo_Excel = Nothing
End Sub

Public Sub AddNewOfferData(ByVal as_StoredProc As String)
On Error GoTo ErrorHandler
    
    If UBound(mo_TempData) >= 0 Then
      ReDim Preserve mo_TempData(UBound(mo_TempData) + 1)
    Else
      ReDim mo_TempData(0)
    End If
    mo_TempData(UBound(mo_TempData)) = as_StoredProc
    Exit Sub
ErrorHandler:
    Call ErrorHandler("AddNewOfferData")
End Sub

Public Sub AddNewOfferTable(ByVal as_DetailType As eDPCOfferDetailIsAlt, ByVal as_Request As String)
On Error GoTo ErrorHandler
    
    Dim lo_TemplateTable As tOFFER_TEMPLATE_TABLE
       
    lo_TemplateTable.DetailType = as_DetailType
    lo_TemplateTable.Request = as_Request
    
    If UBound(mo_TempTables) >= 0 Then
      ReDim Preserve mo_TempTables(UBound(mo_TempTables) + 1)
    Else
      ReDim mo_TempTables(0)
    End If
    mo_TempTables(UBound(mo_TempTables)) = lo_TemplateTable
    Exit Sub
ErrorHandler:
    Call ErrorHandler("AddNewOfferTable")
End Sub

Public Sub AddNewOfferTempTable(ByVal as_Request As String)
On Error GoTo ErrorHandler
    
    Dim lo_TemplateTable As tOFFER_TEMPLATE_TABLE
       
    'lo_TemplateTable.DetailType = as_DetailType
    lo_TemplateTable.Request = as_Request
    
    If UBound(mo_TempTables) >= 0 Then
      ReDim Preserve mo_TempTables(UBound(mo_TempTables) + 1)
    Else
      ReDim mo_TempTables(0)
    End If
    mo_TempTables(UBound(mo_TempTables)) = lo_TemplateTable
    Exit Sub
ErrorHandler:
    Call ErrorHandler("AddNewOfferTempTable")
End Sub

Public Function ProcessOfferTempFile(ByVal as_filePath As String, ByRef as_ErrorMsg As String, Optional ab_Visible = True)
On Error GoTo ErrorHandler

Dim ll_Index As Long

#If LIVE = 1 Then
    Dim lo_TemplateWorkbook As Object  ' Excel.Workbook
    Dim lo_WorkBook As Object
    Dim lo_Range As Object
    Dim lo_WorkSheet As Object
#Else
    Dim lo_TemplateWorkbook As Excel.Workbook
    Dim lo_WorkBook As Excel.Workbook
    Dim lo_Range As Excel.Range
    Dim lo_WorkSheet As Excel.Worksheet
#End If
   
    ProcessOfferTempFile = False
    as_ErrorMsg = ""
    ' Open excel document
    Set lo_TemplateWorkbook = OpenExcelDocument(as_filePath)
        
    Set lo_WorkBook = NewExcelDocument
    If lo_WorkBook Is Nothing Then
      Exit Function
    End If
    Call CopyTemplate(lo_TemplateWorkbook, lo_WorkBook)
    Set lo_WorkSheet = lo_WorkBook.Worksheets(1)
    Call ReplaceScreenConstants(lo_WorkSheet)
    
    For ll_Index = 0 To UBound(mo_TempData)
      Call ReplaceRequestData(lo_WorkSheet, mo_TempData(ll_Index))
    Next
    
    ' process tables
    For ll_Index = 0 To UBound(mo_TempTables)
        Call ReplaceCapOfferTempTable(lo_WorkSheet, mo_TempTables(ll_Index).Request)
    Next
    
    Call AutoFitMergedCellRowHeight(lo_WorkSheet)
    Call lo_WorkSheet.Cells(1, 1).Select
    mo_Excel.Visible = ab_Visible
    Call lo_WorkBook.Activate
    Call ExportClose(lo_WorkBook)
    Set lo_WorkSheet = Nothing
    Set lo_WorkBook = Nothing
    ProcessOfferTempFile = True
    Exit Function
ErrorHandler:
    Call mo_Tools.UpdateError(True)
    Call lo_WorkBook.Close(False)
    Call ExportClose(Nothing)
    Set lo_WorkSheet = Nothing
    Set lo_WorkBook = Nothing
    Call mo_Tools.UpdateError(False)
    as_ErrorMsg = Err.Description
End Function

Public Function ProcessOfferFile(ByVal as_filePath As String, ByRef as_ErrorMsg As String, Optional ab_Visible = True)
On Error GoTo ErrorHandler

Dim ll_Index As Long

#If LIVE = 1 Then
    Dim lo_TemplateWorkbook As Object  ' Excel.Workbook
    Dim lo_WorkBook As Object
    Dim lo_Range As Object
    Dim lo_WorkSheet As Object
#Else
    Dim lo_TemplateWorkbook As Excel.Workbook
    Dim lo_WorkBook As Excel.Workbook
    Dim lo_Range As Excel.Range
    Dim lo_WorkSheet As Excel.Worksheet
#End If
   
    ProcessOfferFile = False
    as_ErrorMsg = ""
    ' Open excel document
    Set lo_TemplateWorkbook = OpenExcelDocument(as_filePath)
        
    Set lo_WorkBook = NewExcelDocument
    If lo_WorkBook Is Nothing Then
      Exit Function
    End If
    Call CopyTemplate(lo_TemplateWorkbook, lo_WorkBook)
    Set lo_WorkSheet = lo_WorkBook.Worksheets(1)
    Call ReplaceScreenConstants(lo_WorkSheet)
    
    For ll_Index = 0 To UBound(mo_TempData)
      Call ReplaceRequestData(lo_WorkSheet, mo_TempData(ll_Index))
    Next
    
    ' process tables
    For ll_Index = 0 To UBound(mo_TempTables)
      Select Case mo_TempTables(ll_Index).DetailType
      Case eDPCOfferDetailIsAlt.maMain
        Call ReplaceMainTable(lo_WorkSheet, mo_TempTables(ll_Index).Request)
      Case eDPCOfferDetailIsAlt.maAltenative
        Call ReplaceAlternativeTable(lo_WorkSheet, mo_TempTables(ll_Index).Request)
      Case eDPCOfferDetailIsAlt.maOption
        Call ReplaceOptionTable(lo_WorkSheet, mo_TempTables(ll_Index).Request)
      Case Else
      End Select
    Next
    
    Call AutoFitMergedCellRowHeight(lo_WorkSheet)
    Call lo_WorkSheet.Cells(1, 1).Select
    mo_Excel.Visible = ab_Visible
    Call lo_WorkBook.Activate
    Call ExportClose(lo_WorkBook)
    Set lo_WorkSheet = Nothing
    Set lo_WorkBook = Nothing
    ProcessOfferFile = True
    Exit Function
ErrorHandler:
    Call mo_Tools.UpdateError(True)
    Call lo_WorkBook.Close(False)
    Call ExportClose(Nothing)
    Set lo_WorkSheet = Nothing
    Set lo_WorkBook = Nothing
    Call mo_Tools.UpdateError(False)
    as_ErrorMsg = Err.Description
End Function

Private Sub ReplaceScreenConstants(ByVal ao_workSheet As Object)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lo_Cell As Object
Dim lo_Range As Object
Dim ls_Formula As String

  Set lo_Range = ao_workSheet.Range(ao_workSheet.PageSetup.PrintArea)
  
  If ms_ScreenName <> "" Then
    ls_req = "exec screen_csts '" & ms_ScreenName & "','" & ms_Language_Code & "'"
  Else
    ls_req = "exec screen_csts '" & SCREEN_NAME & "','" & ms_Language_Code & "'"
  End If
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  For Each lo_Cell In lo_Range
    ls_Formula = lo_Cell.Formula
    If InStr(1, ls_Formula, "$lbl_", vbTextCompare) > 0 Then
      If Left(ls_Formula, 1) = "=" Then
        Call mo_Db.First(lc_Cursor)
        While Not mo_Db.EOF(lc_Cursor)
          'ls_Formula = Replace(ls_Formula, mo_Db.GetFields(lc_Cursor, "Field_Name"), CStr(ConvertCodePageFromAnsi(mo_Db.GetFields(lc_Cursor, "Local_Text"), ml_CodePage)), , , vbTextCompare)
          ls_Formula = ReplaceValue(ls_Formula, mo_Db.GetFields(lc_Cursor, "Field_Name"), mo_Db.GetFieldType(lc_Cursor, "Local_Text"), mo_Db.GetFields(lc_Cursor, "Local_Text"))
          Call mo_Db.Next(lc_Cursor)
        Wend
        lo_Cell.Formula = ls_Formula
      Else
        If mo_Db.Find(lc_Cursor, "Field_Name", CStr(lo_Cell.Value2)) >= 0 Then
          lo_Cell.Value2 = CStr(ConvertCodePageFromAnsi(mo_Db.GetFields(lc_Cursor, "Local_Text"), ml_CodePage))
        End If
      End If
    End If
  Next
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceScreenConstants")
End Sub

Private Sub ReplaceRequestData(ByVal ao_workSheet As Object, ByVal as_req As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long, ll_FieldIdx As Long
Dim lo_Cell As Object
Dim lo_Range As Object
Dim ls_Value As String

  Set lo_Range = ao_workSheet.Range(ao_workSheet.PageSetup.PrintArea)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, as_req)
  For Each lo_Cell In lo_Range
    'ls_Value = CStr(lo_Cell.Value2)
    ls_Value = CStr(lo_Cell.Formula)
    If ls_Value <> "" Then
      For ll_FieldIdx = 0 To mo_Db.FieldCount(lc_Cursor) - 1
        ls_Value = ReplaceValue(ls_Value, "$" & mo_Db.GetFieldName(lc_Cursor, ll_FieldIdx) & "$", mo_Db.GetFieldType(lc_Cursor, ll_FieldIdx), mo_Db.GetFields(lc_Cursor, ll_FieldIdx))
      Next
      'lo_Cell.Value2 = ls_Value
      lo_Cell.Formula = ls_Value
    End If
  Next
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceRequestData")
End Sub

Private Function ReplaceValue(ByVal as_Data As String, ByVal as_FieldName As String, ByVal ae_FieldType As ArmSysType, ByVal av_Value As Variant, Optional ByVal al_MaxLen As Long = 0) As String
On Error GoTo ErrHandler

  Select Case ae_FieldType
  Case ArmSysType.DBTYPE_STR, ArmSysType.DBTYPE_BSTR
    av_Value = Replace(av_Value, """", """""", , , vbTextCompare)
    If al_MaxLen = 0 Then
      ReplaceValue = Replace(as_Data, as_FieldName, CStr(ConvertCodePageFromAnsi(av_Value, ml_CodePage)), , , vbTextCompare)
    Else
      ReplaceValue = Replace(as_Data, as_FieldName, CStr(ConvertCodePageFromAnsi(Left(av_Value, al_MaxLen), ml_CodePage)), , , vbTextCompare)
    End If
  Case ArmSysType.DBTYPE_I4
    ReplaceValue = Replace(as_Data, as_FieldName, CInt(av_Value), , , vbTextCompare)
  Case ArmSysType.DBTYPE_R4, ArmSysType.DBTYPE_R8
    ReplaceValue = Replace(as_Data, as_FieldName, CStr(Round(av_Value, 2)), , , vbTextCompare)
  Case ArmSysType.DBTYPE_DATE
    If av_Value = 0 Then
      ReplaceValue = Replace(as_Data, as_FieldName, "", , , vbTextCompare)
    Else
      ReplaceValue = Replace(as_Data, as_FieldName, Format(av_Value, "dd\/mm\/yyyy"), , , vbTextCompare)
    End If
  Case Else
    If al_MaxLen = 0 Then
      ReplaceValue = Replace(as_Data, as_FieldName, CStr(ConvertCodePageFromAnsi(av_Value, ml_CodePage)), , , vbTextCompare)
    Else
      ReplaceValue = Replace(as_Data, as_FieldName, CStr(ConvertCodePageFromAnsi(Left(av_Value, al_MaxLen), ml_CodePage)), , , vbTextCompare)
    End If
  End Select
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValue")
End Function

Private Sub ReplaceCapOfferTempTable(ByVal ao_workSheet As Object, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call ao_workSheet.Activate
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, as_Request)
  While Not mo_Db.EOF(lc_Cursor)

    Call CreateRowRange(lc_Cursor, ao_workSheet, "DetailMain", "DetailMain")
    Call mo_Db.Next(lc_Cursor)
  
  Wend
  Call mo_Db.Close(lc_Cursor)
  Call ao_workSheet.Range("DetailMain").Delete(XlDeleteShiftDirection.xlShiftUp)

  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceCapOfferTempTable")
End Sub

Private Sub ReplaceMainTable(ByVal ao_workSheet As Object, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call ao_workSheet.Activate
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, as_Request)
  While Not mo_Db.EOF(lc_Cursor)
    If mo_Db.GetFields(lc_Cursor, "GroupSection") = 1 Then
      Call CreateRowRange(lc_Cursor, ao_workSheet, "DetailMain", "DetailMain")
      If mo_Db.GetFields(lc_Cursor, "CAT_Id") = eDPCCategory.cgSubconstruction Then
        Call CreateRowRange(lc_Cursor, ao_workSheet, "DetailMain", "SubconstructionMain")
      End If
    Else
      If mo_Db.GetFields(lc_Cursor, "CAT_Id") = eDPCCategory.cgSubconstruction Then
        Call CreateRowRange(lc_Cursor, ao_workSheet, "DetailMain", "SubconstructionChild")
      Else
        Call CreateRowRange(lc_Cursor, ao_workSheet, "DetailMain", "DetailChild")
      End If
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Call ao_workSheet.Range("DetailMain").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("DetailChild").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("SubconstructionMain").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("SubconstructionChild").Delete(XlDeleteShiftDirection.xlShiftUp)
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceRequestTable")
End Sub

Private Sub ReplaceAlternativeTable(ByVal ao_workSheet As Object, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call ao_workSheet.Activate
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, as_Request)
  If mo_Db.RowCount(lc_Cursor) = 0 Then
    Call ao_workSheet.Range("AlternativeHeader").Delete(XlDeleteShiftDirection.xlShiftUp)
  Else
    While Not mo_Db.EOF(lc_Cursor)
      If mo_Db.GetFields(lc_Cursor, "GroupSection") = 1 Then
        Call CreateRowRange(lc_Cursor, ao_workSheet, "AlternativeMain", "AlternativeMain")
        If mo_Db.GetFields(lc_Cursor, "CAT_Id") = eDPCCategory.cgSubconstruction Then
          Call CreateRowRange(lc_Cursor, ao_workSheet, "AlternativeMain", "AlternativeSubconstructionMain")
        End If
      Else
        If mo_Db.GetFields(lc_Cursor, "CAT_Id") = eDPCCategory.cgSubconstruction Then
          Call CreateRowRange(lc_Cursor, ao_workSheet, "AlternativeMain", "AlternativeSubconstructionChild")
        Else
          Call CreateRowRange(lc_Cursor, ao_workSheet, "AlternativeMain", "AlternativeChild")
        End If
      End If
      Call mo_Db.Next(lc_Cursor)
    Wend
  End If
  Call mo_Db.Close(lc_Cursor)
  Call ao_workSheet.Range("AlternativeMain").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("AlternativeChild").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("AlternativeSubconstructionMain").Delete(XlDeleteShiftDirection.xlShiftUp)
  Call ao_workSheet.Range("AlternativeSubconstructionChild").Delete(XlDeleteShiftDirection.xlShiftUp)
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceAlternativeTable")
End Sub

Private Sub ReplaceOptionTable(ByVal ao_workSheet As Object, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call ao_workSheet.Activate
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, as_Request)
  If mo_Db.RowCount(lc_Cursor) = 0 Then
    Call ao_workSheet.Range("OptionHeader").Delete(XlDeleteShiftDirection.xlShiftUp)
  Else
    While Not mo_Db.EOF(lc_Cursor)
      Call CreateRowRange(lc_Cursor, ao_workSheet, "OptionMain", "OptionMain")
      Call mo_Db.Next(lc_Cursor)
    Wend
  End If
  Call mo_Db.Close(lc_Cursor)
  Call ao_workSheet.Range("OptionMain").Delete(XlDeleteShiftDirection.xlShiftUp)
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceOptionTable")
End Sub

Private Sub CreateRowRange(ByVal ac_Cursor As Long, ByVal ao_workSheet As Object, ByVal as_BeforeRangeName As String, ByVal as_TemplateRangeName As String)
On Error GoTo ErrHandler

Dim lo_TemplateRange As Object
Dim lo_Range As Object

  Set lo_TemplateRange = ao_workSheet.Range(as_TemplateRangeName)
  Call lo_TemplateRange.Copy
  Call ao_workSheet.Range(as_BeforeRangeName).Insert(XlInsertShiftDirection.xlShiftDown)
  Set lo_Range = ao_workSheet.Range(as_BeforeRangeName).Offset(-lo_TemplateRange.Rows.Count, 0)
  Set lo_Range = lo_Range.Resize(lo_TemplateRange.Rows.Count, lo_TemplateRange.Columns.Count)
  Call ReplaceRangeValue(ac_Cursor, lo_Range)
  Exit Sub
ErrHandler:
  Call ErrorHandler("CreateRowRange")
End Sub

Private Sub ReplaceRangeValue(ByVal ac_Cursor As Long, ByVal ao_Range As Object)
On Error GoTo ErrHandler

Dim ls_Value As String
Dim ll_FieldIdx As Long
Dim lo_Cell As Object

  If Not ao_Range Is Nothing Then
    For Each lo_Cell In ao_Range
      ls_Value = CStr(lo_Cell.Formula)
      If ls_Value <> "" Then
        If Left(ls_Value, 1) = "=" Then
          For ll_FieldIdx = 0 To mo_Db.FieldCount(ac_Cursor) - 1
            ls_Value = ReplaceValue(ls_Value, "$" & mo_Db.GetFieldName(ac_Cursor, ll_FieldIdx) & "$", mo_Db.GetFieldType(ac_Cursor, ll_FieldIdx), mo_Db.GetFields(ac_Cursor, ll_FieldIdx), 255)
          Next
        Else
          For ll_FieldIdx = 0 To mo_Db.FieldCount(ac_Cursor) - 1
            ls_Value = ReplaceValue(ls_Value, "$" & mo_Db.GetFieldName(ac_Cursor, ll_FieldIdx) & "$", mo_Db.GetFieldType(ac_Cursor, ll_FieldIdx), mo_Db.GetFields(ac_Cursor, ll_FieldIdx))
          Next
        End If
        lo_Cell.Formula = ls_Value
      End If
    Next
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReplaceRangeValue")
End Sub

Private Function CopyTemplate(ByVal ao_WorkBookSrc As Object, ByVal ao_WorkBookDst As Object, Optional al_Index As Long = 0) As Boolean
On Error GoTo ErrorHandler

Dim lo_WorkSheetSrc As Object
Dim lo_WorkSheetDst As Object
Dim lo_Name As Object

  Call ao_WorkBookSrc.Activate
  Set lo_WorkSheetSrc = ao_WorkBookSrc.Worksheets(1)
  Call lo_WorkSheetSrc.Activate
  Call lo_WorkSheetSrc.Cells.Copy
  
  Call ao_WorkBookDst.Activate
  If al_Index >= ao_WorkBookDst.Worksheets.Count Then
    Call ao_WorkBookDst.Worksheets.Add(, ao_WorkBookDst.Worksheets(al_Index))
  End If
  Set lo_WorkSheetDst = ao_WorkBookDst.Worksheets(al_Index + 1)
  Call lo_WorkSheetDst.Activate
  Call lo_WorkSheetDst.Cells.Select
  Call lo_WorkSheetDst.Paste
  Call lo_WorkSheetDst.Cells(1, 1).Select
  lo_WorkSheetDst.PageSetup.PrintArea = lo_WorkSheetSrc.PageSetup.PrintArea
  ao_WorkBookDst.Application.PrintCommunication = False
  lo_WorkSheetDst.PageSetup.FitToPagesWide = 1
  lo_WorkSheetDst.PageSetup.FitToPagesTall = False
  ao_WorkBookDst.Application.PrintCommunication = True
  ' Loop through all of the defined names in the source workbook.
  On Error Resume Next
  For Each lo_Name In ao_WorkBookSrc.Names
    Call ao_WorkBookDst.Names.Add(lo_Name.Name, lo_Name.Value)
  Next
On Error GoTo ErrorHandler
  ao_WorkBookSrc.Application.CutCopyMode = False
  Call ao_WorkBookSrc.Close(False)
  CopyTemplate = True
  Exit Function
ErrorHandler:
  CopyTemplate = False
End Function

Private Sub AutoFitMergedCellRowHeight(ao_workSheet As Object)
On Error GoTo ErrorHandler
' sets row heights in sheet Sh.
' Excel doesn't correctly set row height when merged cells have wrapped text
  Dim sHeight As Single
  Dim sBestHeight As Single
  Dim cSizer As Object
  Dim lo_Cell As Object, rRow As Object
  
  ' this process is only relevant to worksheets, not chart sheets
  If TypeName(ao_workSheet) = "Worksheet" Then
    ' text wrapping done in some cells in the sheet
    'Workbooks.Add xlWorksheet ' temporary workbook
    Set cSizer = ao_workSheet.Parent.Worksheets(2).Range("A1")   ' a cell to use as workspace
    
    For Each rRow In ao_workSheet.UsedRange.Rows
      If IsNull(rRow.WrapText) Or rRow.WrapText Then
        ' there are cells on this row with wrapped text
        If IsNull(rRow.MergeCells) Or rRow.MergeCells Then
          ' no merged cells so can use Excel's autofit
          'Call rRow.EntireRow.AutoFit
        'Else
          ' row has merged cells and wrapped text
          sBestHeight = 12
          For Each lo_Cell In rRow.Cells
            ' copy the content of the cell to a spare cell in Terms and Autofit there
            If lo_Cell.Address = lo_Cell.MergeArea.Range("A1").Address _
                 And lo_Cell.WrapText And Not lo_Cell.EntireColumn.Hidden Then
              ' first of a merged cell, or a single cell, with wrapped text
              ' and column not hidden
              ' set the single cell in Terms to match the (merged) cell here
              cSizer.Value = lo_Cell.Text
              cSizer.Font.Name = lo_Cell.Font.Name
              cSizer.Font.Size = lo_Cell.Font.Size
              cSizer.Font.Bold = lo_Cell.Font.Bold
              ' Width is measured in Twips and we can find the width of the MergeArea
              ' but we can only set the ColumnWidth which is measured in different units
              ' so scale the Width appropriately
              cSizer.EntireColumn.ColumnWidth = lo_Cell.MergeArea.Width * cSizer.ColumnWidth / cSizer.Width
              cSizer.WrapText = True
              ' use AutoFit to find the right row height for this cell
              Call cSizer.EntireRow.AutoFit
              ' get the height
              sHeight = cSizer.RowHeight
              ' if the cell is merged vertically then we need less height than this
              If lo_Cell.MergeArea.Rows.Count > 1 Then
                ' adjust height down for later rows
                sHeight = sHeight - (lo_Cell.MergeArea.Rows.Count - 1) * (lo_Cell.Font.Size + 2.75)
              End If
            Else
              sHeight = lo_Cell.Font.Size + 2.75
            End If
            ' take the greatest height for this row so far
            If sHeight > sBestHeight Then sBestHeight = sHeight
          Next
          ' if the row isn't the correct height
          If rRow.EntireRow.RowHeight < sBestHeight Then
            ' set it to the correct height
            rRow.EntireRow.RowHeight = sBestHeight
          End If
        End If
      End If
    Next
    ' close the helper workbook
    'ActiveWorkbook.Close False
  End If
  Exit Sub
ErrorHandler:
  Call ErrorHandler("AutoFitMergedCellRowHeight")
End Sub

Private Function ExportClose(ByVal ao_Workbook As Object) As Boolean
On Error GoTo ErrorHandler
  
  ExportClose = False
  If Not (mo_Excel Is Nothing) Then
    If Not ao_Workbook Is Nothing Then
      If ao_Workbook.Worksheets(1).Name <> ms_OriginalWorkSheetName Then
        ao_Workbook.Worksheets(1).Name = ms_OriginalWorkSheetName
      End If
    End If
    mo_Excel.Application.Visible = True
    mo_Excel.ScreenUpdating = True
    Set mo_Excel = Nothing
    ExportClose = True
  End If
  Exit Function
ErrorHandler:
  ExportClose = False
End Function

Private Function OpenExcelDocument(as_Name As String) As Object
Dim lo_WorkBook As Object
Dim lo_TemplateBook As Object
Dim lo_WorkSheet As Object
Dim lb_Found As Boolean

    Set OpenExcelDocument = Nothing
    
On Error GoTo Err_NotLoaded
    
    Set mo_Excel = GetObject(, "Excel.Application")
    
    If mo_Excel Is Nothing Then
        Set mo_Excel = CreateObject("Excel.Application")
    End If
    
    If mo_Excel Is Nothing Then GoTo ErrorHandler
    
On Error GoTo ErrorHandler
    
    lb_Found = False
    For Each lo_WorkBook In mo_Excel.Workbooks
      If StrComp(lo_WorkBook.FullName, as_Name, vbTextCompare) = 0 Then
        Set lo_TemplateBook = lo_WorkBook
        lb_Found = True
      End If
    Next
    If Not lb_Found Then
      Set lo_TemplateBook = mo_Excel.Workbooks.Open(as_Name)
    End If
    
    Set OpenExcelDocument = lo_TemplateBook
    
    Set lo_WorkSheet = lo_TemplateBook.Worksheets(1)
    mo_Excel.Application.Visible = False
    lo_WorkSheet.Application.Visible = False
    Exit Function
Err_NotLoaded:
    If Err.Number = 429 Then
        Resume Next
    End If
ErrorHandler:
    Set mo_Excel = Nothing
End Function

Private Function NewExcelDocument() As Object
Dim lo_WorkBook As Object
Dim lo_WorkSheet As Object

    Set NewExcelDocument = Nothing
    
On Error GoTo Err_NotLoaded
    
    Set mo_Excel = GetObject(, "Excel.Application")
    
    If mo_Excel Is Nothing Then
        Set mo_Excel = CreateObject("Excel.Application")
    End If
    
    If mo_Excel Is Nothing Then GoTo ErrorHandler
    
On Error GoTo ErrorHandler
    
    Set lo_WorkBook = mo_Excel.Workbooks.Add
    
    Set lo_WorkSheet = lo_WorkBook.Worksheets(1)
    If lo_WorkBook.Worksheets.Count < 2 Then
      Call lo_WorkBook.Worksheets.Add(, lo_WorkSheet)
    End If
    
    Call lo_WorkSheet.Activate
    ms_OriginalWorkSheetName = lo_WorkSheet.Name
    If lo_WorkSheet.Name <> TEMPLATE_SHEET1_NAME Then
      lo_WorkSheet.Name = TEMPLATE_SHEET1_NAME
    End If
    mo_Excel.Application.Visible = False
    lo_WorkSheet.Application.Visible = False
    mo_Excel.ScreenUpdating = False
    
    Set NewExcelDocument = lo_WorkBook
    Exit Function
Err_NotLoaded:
    If Err.Number = 429 Then
        Resume Next
    End If
ErrorHandler:
    Set mo_Excel = Nothing
End Function

Private Function SetCell(ao_Sheet As Object, al_Row As Long, al_Col As Long, av_Value As Variant)
On Error GoTo ErrorHandler
  
  If VarType(av_Value) = vbString Then
    ao_Sheet.Cells(al_Row, al_Col) = ConvertCodePageFromAnsi("'" & Trim(CStr(av_Value)), ml_CodePage)
  Else
    ao_Sheet.Cells(al_Row, al_Col) = av_Value
  End If
  Exit Function
ErrorHandler:
End Function

Private Function SetCellAttr(ao_Sheet As Object, al_Row As Long, al_Col As Long, ab_Bold As Boolean)
On Error GoTo ErrorHandler
  
  ao_Sheet.Cells(al_Row, al_Col).Font.Bold = ab_Bold
  Exit Function
ErrorHandler:
End Function

Private Function GetCell(ao_Sheet As Object, al_Row As Long, al_Col As Long) As Variant
On Error GoTo ErrorHandler

  GetCell = ConvertCodePageFromUnicode(ao_Sheet.Cells(al_Row, al_Col), ml_CodePage)
  Exit Function
ErrorHandler:
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, "CExcelTemplateProcessor" & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub



